// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/web_socket.mojom
//

package org.chromium.mojom.mojo;

class WebSocket_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<WebSocket, WebSocket.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<WebSocket, WebSocket.Proxy>() {
    
        public String getName() {
            return "mojo::WebSocket";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, WebSocket impl) {
            return new Stub(core, impl);
        }
    
        public WebSocket[] buildArray(int size) {
          return new WebSocket[size];
        }
    };

    private static final int CONNECT_ORDINAL = 0;
    private static final int SEND_ORDINAL = 1;
    private static final int FLOW_CONTROL_ORDINAL = 2;
    private static final int CLOSE_ORDINAL = 3;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements WebSocket.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connect(String url, String[] protocols, String origin, org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream, WebSocketClient client) {
            WebSocketConnectParams _message = new WebSocketConnectParams();
            _message.url = url;
            _message.protocols = protocols;
            _message.origin = origin;
            _message.sendStream = sendStream;
            _message.client = client;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CONNECT_ORDINAL)));
        }

        @Override
        public void send(boolean fin, int type, int numBytes) {
            WebSocketSendParams _message = new WebSocketSendParams();
            _message.fin = fin;
            _message.type = type;
            _message.numBytes = numBytes;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(SEND_ORDINAL)));
        }

        @Override
        public void flowControl(long quota) {
            WebSocketFlowControlParams _message = new WebSocketFlowControlParams();
            _message.quota = quota;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(FLOW_CONTROL_ORDINAL)));
        }

        @Override
        public void close(short code, String reason) {
            WebSocketCloseParams _message = new WebSocketCloseParams();
            _message.code = code;
            _message.reason = reason;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CLOSE_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<WebSocket> {

        Stub(org.chromium.mojo.system.Core core, WebSocket impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                WebSocket_Internal.MANAGER, messageWithHeader);
                    case CONNECT_ORDINAL: {
                        WebSocketConnectParams data =
                                WebSocketConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connect(data.url, data.protocols, data.origin, data.sendStream, data.client);
                        return true;
                    }
                    case SEND_ORDINAL: {
                        WebSocketSendParams data =
                                WebSocketSendParams.deserialize(messageWithHeader.getPayload());
                        getImpl().send(data.fin, data.type, data.numBytes);
                        return true;
                    }
                    case FLOW_CONTROL_ORDINAL: {
                        WebSocketFlowControlParams data =
                                WebSocketFlowControlParams.deserialize(messageWithHeader.getPayload());
                        getImpl().flowControl(data.quota);
                        return true;
                    }
                    case CLOSE_ORDINAL: {
                        WebSocketCloseParams data =
                                WebSocketCloseParams.deserialize(messageWithHeader.getPayload());
                        getImpl().close(data.code, data.reason);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), WebSocket_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class WebSocketConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 48;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(48, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String url;
        public String[] protocols;
        public String origin;
        public org.chromium.mojo.system.DataPipe.ConsumerHandle sendStream;
        public WebSocketClient client;
    
        private WebSocketConnectParams(int version) {
            super(STRUCT_SIZE, version);
            sendStream = org.chromium.mojo.system.InvalidHandle.INSTANCE;
        }
    
        public WebSocketConnectParams() {
            this(0);
        }
    
        public static WebSocketConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketConnectParams result = new WebSocketConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.url = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
                {
                    org.chromium.mojo.bindings.DataHeader si1 = decoder1.readDataHeaderForPointerArray(org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                    result.protocols = new String[si1.elementsOrVersion];
                    for (int i1 = 0; i1 < si1.elementsOrVersion; ++i1) {
                        result.protocols[i1] = decoder1.readString(org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i1, false);
                    }
                }
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(24, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.sendStream = decoder0.readConsumerHandle(32, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(36, false, WebSocketClient.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(url, 8, false);
            if (protocols == null) {
                encoder0.encodeNullPointer(16, false);
            } else {
                org.chromium.mojo.bindings.Encoder encoder1 = encoder0.encodePointerArray(protocols.length, 16, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
                for (int i0 = 0; i0 < protocols.length; ++i0) {
                    encoder1.encode(protocols[i0], org.chromium.mojo.bindings.DataHeader.HEADER_SIZE + org.chromium.mojo.bindings.BindingsHelper.POINTER_SIZE * i0, false);
                }
            }
            encoder0.encode(origin, 24, false);
            encoder0.encode(sendStream, 32, false);
            encoder0.encode(client, 36, false, WebSocketClient.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketConnectParams other = (WebSocketConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.url, other.url))
                return false;
            if (!java.util.Arrays.deepEquals(this.protocols, other.protocols))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sendStream, other.sendStream))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.client, other.client))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(url);
            result = prime * result + java.util.Arrays.deepHashCode(protocols);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sendStream);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(client);
            return result;
        }
    }

    static final class WebSocketSendParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public boolean fin;
        public int type;
        public int numBytes;
    
        private WebSocketSendParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketSendParams() {
            this(0);
        }
    
        public static WebSocketSendParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketSendParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketSendParams result = new WebSocketSendParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.fin = decoder0.readBoolean(8, 0);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.type = decoder0.readInt(12);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.numBytes = decoder0.readInt(16);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(fin, 8, 0);
            encoder0.encode(type, 12);
            encoder0.encode(numBytes, 16);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketSendParams other = (WebSocketSendParams) object;
            if (this.fin != other.fin)
                return false;
            if (this.type != other.type)
                return false;
            if (this.numBytes != other.numBytes)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(type);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(numBytes);
            return result;
        }
    }

    static final class WebSocketFlowControlParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 16;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(16, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public long quota;
    
        private WebSocketFlowControlParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketFlowControlParams() {
            this(0);
        }
    
        public static WebSocketFlowControlParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketFlowControlParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketFlowControlParams result = new WebSocketFlowControlParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.quota = decoder0.readLong(8);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(quota, 8);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketFlowControlParams other = (WebSocketFlowControlParams) object;
            if (this.quota != other.quota)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(quota);
            return result;
        }
    }

    static final class WebSocketCloseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public short code;
        public String reason;
    
        private WebSocketCloseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public WebSocketCloseParams() {
            this(0);
        }
    
        public static WebSocketCloseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static WebSocketCloseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            WebSocketCloseParams result = new WebSocketCloseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.code = decoder0.readShort(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.reason = decoder0.readString(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(code, 8);
            encoder0.encode(reason, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            WebSocketCloseParams other = (WebSocketCloseParams) object;
            if (this.code != other.code)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.reason, other.reason))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(code);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(reason);
            return result;
        }
    }

}

